<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\User;

class DatabaseSeeder extends Seeder
{
    public function run()
    {
        // Seed Roles with Permissions
        $roles = [
            [
                'Name' => 'Super Admin',
                'Permissions' => [
                    'manage_users', 'manage_roles', 'manage_courses', 'manage_exams', 'manage_jobs',
                    'manage_content', 'view_analytics', 'approve_certifications', 'approve_job_posts',
                    'manage_payments', 'manage_subscriptions', 'manage_notifications', 'manage_security'
                ]
            ],
            [
                'Name' => 'Candidate',
                'Permissions' => [
                    'view_courses', 'enroll_courses', 'take_exams', 'view_certifications', 'apply_jobs',
                    'view_profile', 'update_profile', 'access_training', 'use_interview_tools',
                    'send_messages', 'join_groups', 'upgrade_subscription'
                ]
            ],
            [
                'Name' => 'Company',
                'Permissions' => [
                    'post_jobs', 'review_applicants', 'hire_candidates', 'view_candidate_results',
                    'manage_company_profile', 'search_candidates', 'schedule_interviews',
                    'track_applications', 'view_hiring_reports', 'upgrade_subscription'
                ]
            ],
        ];

        foreach ($roles as $role) {
            Role::create($role);
        }

        // Seed a Super Admin User
        $superAdmin = User::create([
            'Email' => 'superadmin@example.com',
            'mobile_number' => '1234567890',
            'Password_hash' => bcrypt('password123'),
            'User_type' => 'super_admin',
            'Status' => 'active'
        ]);
        $superAdmin->roles()->attach(Role::where('Name', 'Super Admin')->first()->Role_id);
        // Optional: Verify role assignment
        if ($superAdmin->hasRole('Super Admin')) {
            echo "Super Admin role assigned successfully.\n";
        }

        // Seed a Candidate User
        $candidate = User::create([
            'Email' => 'candidate@example.com',
            'mobile_number' => '9876543210',
            'Password_hash' => bcrypt('password123'),
            'User_type' => 'candidate',
            'Status' => 'active'
        ]);
        $candidate->roles()->attach(Role::where('Name', 'Candidate')->first()->Role_id);
        // Optional: Verify role assignment
        if ($candidate->hasRole('Candidate')) {
            echo "Candidate role assigned successfully.\n";
        }

        // Seed a Company User
        $company = User::create([
            'Email' => 'company@example.com',
            'mobile_number' => '5555555555',
            'Password_hash' => bcrypt('password123'),
            'User_type' => 'company',
            'Status' => 'active'
        ]);
        $company->roles()->attach(Role::where('Name', 'Company')->first()->Role_id);
        // Optional: Verify role assignment
        if ($company->hasRole('Company')) {
            echo "Company role assigned successfully.\n";
        }
    }
}
